#include <iostream>
#include <vector>
using namespace std;

long long minimum(int x, int k)
{
	return min(x, k);
}

long long maximum(int x, int k)
{
	return max(x, k);
}

long long sum(int x, int k)
{
	return x + k;
}

int main()
{
	int n; cin >> n;
	vector<int> function_types(n);
	vector<int> coeffs(n);
	for (int i = 0; i < n; i++) cin >> function_types[i];
	for (int i = 0; i < n; i++) cin >> coeffs[i];

	int q; cin >> q;
	vector<long long> prefix(n);
	vector<long long> prefix_of_prefixes(n);

	prefix[0] = coeffs[0];
	prefix_of_prefixes[0] = prefix[0];
	for (int i = 1; i < n; i++)
	{
		prefix[i] = coeffs[i] + prefix[i - 1];
		prefix_of_prefixes[i] = prefix[i] + prefix_of_prefixes[i - 1];
	}
	while (q--)
	{
		int l, r, x; cin >> l >> r >> x;
		l--;
		long long query_sum = 0;
		if (n <= 1000 && q <= 1000)
		{
			for (int i = l; i < r; i++)
			{
				long long (*func)(int, int);
				if (function_types[i] == 1) func = &minimum;
				else if (function_types[i] == 2) func = &maximum;
				else func = &sum;

				query_sum += func(x, coeffs[i]);
				x = func(x, coeffs[i]);
			}
		}
		else
		{
			query_sum = (r - l) * x;
			query_sum += prefix_of_prefixes[r] - (r - l) * prefix[l];
		}

		cout << query_sum << endl;
	}
}